/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.filesvr;

import com.ibm.hsc.filesvr.FsByteStream;
import com.ibm.hsc.filesvr.FsConnection;
import com.ibm.hsc.filesvr.FsException;
import com.ibm.hsc.filesvr.FsPacket;
import com.ibm.hsc.filesvr.FsSystem;

public class FsConnectionInfoPacket
extends FsPacket {
    protected static final int CONNECTION_INFO_SERVER_ID = 1;
    protected static final int CONNECTION_INFO_PACKET_LEVEL = 2;
    protected static final int CONNECTION_INFO_SOCKET_ID = 3;
    protected String m_serverId = null;
    protected int m_socketId = -1;
    protected int m_packetSignature = 1179844609;
    protected int m_packetFeatureCode = 65536;

    public FsConnectionInfoPacket(FsConnection fsConnection) {
        super(fsConnection, 2);
        if (this.m_connection != null) {
            this.m_socketId = this.m_connection.getSocketId();
        }
    }

    protected FsConnectionInfoPacket(FsPacket fsPacket) {
        super(fsPacket, 2);
        if (this.m_connection != null) {
            this.m_socketId = this.m_connection.getSocketId();
        }
    }

    protected FsConnectionInfoPacket(FsConnectionInfoPacket fsConnectionInfoPacket) {
        super(fsConnectionInfoPacket);
        this.m_serverId = fsConnectionInfoPacket.m_serverId;
        this.m_socketId = fsConnectionInfoPacket.m_socketId;
        this.m_packetSignature = fsConnectionInfoPacket.m_packetSignature;
        this.m_packetFeatureCode = fsConnectionInfoPacket.m_packetFeatureCode;
    }

    protected void buildData(FsByteStream fsByteStream) throws FsException {
        super.buildData(fsByteStream);
        if (this.getOpCode() != 2) {
            throw new FsException(19, this.getOpCode());
        }
        if (this.m_packetSignature != 1179844609) {
            this.m_packetSignature = 1179844609;
        }
        if (this.m_packetFeatureCode != 65536) {
            this.m_packetFeatureCode = 65536;
        }
        if (this.isResponsePacket()) {
            this.m_serverId = FsSystem.getSystemId();
            if (this.m_serverId != null) {
                fsByteStream.writeInt(1, 1);
                fsByteStream.writeLong(this.m_serverId.length());
                fsByteStream.writeString(this.m_serverId);
            }
            if (this.m_socketId > 0) {
                fsByteStream.writeInt(3, 1);
                fsByteStream.writeLong(this.m_socketId);
            }
        }
        fsByteStream.writeInt(2, 1);
        fsByteStream.writeInt(this.m_packetSignature);
        fsByteStream.writeInt(this.m_packetFeatureCode);
    }

    public int getPacketFeatureCode() {
        return this.m_packetFeatureCode;
    }

    public int getPacketSignature() {
        return this.m_packetSignature;
    }

    public int getSocketId() {
        return this.m_socketId;
    }

    public String getServerId() {
        return this.m_serverId;
    }

    protected void parseData(FsByteStream fsByteStream) throws FsException {
        super.parseData(fsByteStream);
        if (this.getOpCode() != 2) {
            throw new FsException(19, this.getOpCode());
        }
        block5: while (fsByteStream.available() > 0) {
            byte by = fsByteStream.readByte();
            switch (by) {
                case 1: {
                    int n = (int)fsByteStream.readLong();
                    this.m_serverId = fsByteStream.readString(n);
                    continue block5;
                }
                case 2: {
                    this.m_packetSignature = fsByteStream.readInt();
                    this.m_packetFeatureCode = fsByteStream.readInt();
                    continue block5;
                }
                case 3: {
                    this.m_socketId = (int)fsByteStream.readLong();
                    continue block5;
                }
            }
            throw new FsException(1);
        }
        if (this.m_packetSignature != 1179844609) {
            this.m_packetSignature = 1179844609;
        }
        if (this.m_packetFeatureCode != 65536) {
            this.m_packetFeatureCode = 65536;
        }
    }

    public void setPacketFeatureCode(int n) {
        this.m_packetFeatureCode = n;
    }

    public void setPacketSignature(int n) {
        this.m_packetSignature = n;
    }

    protected void setServerId(String string) {
        this.m_serverId = string;
    }

    protected void setSocketId(int n) {
        this.m_socketId = n;
    }
}

